

/****** Object:  UserDefinedFunction [dbo].[UFD_BC_LANC_EXTRATO_PREV_COMP]    Script Date: 08/10/2012 16:42:09 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_BC_LANC_EXTRATO_PREV_COMP]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_BC_LANC_EXTRATO_PREV_COMP]
GO


/****** Object:  UserDefinedFunction [dbo].[UFD_BC_LANC_EXTRATO_PREV_COMP]    Script Date: 08/10/2012 16:42:09 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

----SELECT * FROM UFD_BC_LANC_EXTRATO_PREV_COMP(1,3,'2007-10-11','2007-11-11',0) ORDER BY CD_BC_LANC
CREATE FUNCTION [dbo].[UFD_BC_LANC_EXTRATO_PREV_COMP](
--CREATE FUNCTION UFD_BC_LANC_EXTRATO_PREV_COMP(
												@CD_EMP	INT,
												@CD_CNT	INT,
												@DT_INI	DATETIME,
												@DT_FIM	DATETIME,
												@TP_COMPES INT --0 No Compensado; 1 - Compensado
												)
RETURNS @BC_LANC_EXTRATO TABLE(
												CD_EMP		INT,
												CD_RET		INT,
												DS_RET		NVARCHAR(100),												
												VLR_RET		MONEY)
AS
BEGIN

--Usada para auxiliar o calculo do saldo
DECLARE @VLR_SLD				MONEY
DECLARE @SLD_INI				MONEY
DECLARE @VLR_CHQ_EMP			MONEY
DECLARE @VLR_CHQ_TERC			MONEY
DECLARE @VLR_BC_LANC			MONEY
DECLARE @VLR_LIMITE				MONEY
DECLARE @VLR_CHQ_SEM_COMP		MONEY
DECLARE @VLR_CHQ_COMPES			MONEY
DECLARE @VLR_CHQ_SEM_CONC_COMP	MONEY
DECLARE @DT_ATUAL				DATETIME



SET @SLD_INI = 0 
SET @VLR_CHQ_EMP = 0
set @VLR_CHQ_TERC = 0
SET @VLR_BC_LANC = 0
SET @VLR_CHQ_SEM_COMP = 0


SET @DT_ATUAL = (SELECT CONVERT(VARCHAR(10),GETDATE(), 101))

SET @DT_INI = (SELECT CONVERT(VARCHAR(10),@DT_INI, 101))
SET @DT_FIM = (SELECT CONVERT(VARCHAR(10),@DT_FIM, 101))

SET @SLD_INI = ISNULL((SELECT DBO.UFD_BC_LANC_EXTRATO_SLD(@CD_EMP,@CD_CNT, DATEADD(day, 1, @DT_FIM),0)),0)


--VALOR REFERENTE AOS CHEQUES DA EMPRESA
SET @VLR_CHQ_EMP = ISNULL((SELECT
						SUM(CASE WHEN BC_LANC.TP_LANC = 0 THEN VLR_LANC ELSE -VLR_LANC END) AS VLR_LANC
					FROM
						BC_LANC 
						INNER JOIN BC_LANC_BC_CHQ_LANC ON
							BC_LANC.CD_EMP = BC_LANC_BC_CHQ_LANC.CD_EMP AND
							BC_LANC.CD_BC_LANC = BC_LANC_BC_CHQ_LANC.CD_BC_LANC
						INNER JOIN GLB_DOC ON
							BC_LANC.CD_EMP = GLB_DOC.CD_EMP AND 
							BC_LANC.CD_DOC = GLB_DOC.CD_DOC
					WHERE
						BC_LANC.CD_EMP = @CD_EMP
						AND BC_LANC.CD_CNT = @CD_CNT
						AND BC_LANC.DT_LANCTO <= @DT_FIM
						AND GLB_DOC.TP_DOC = 6
						AND NOT EXISTS (
							SELECT
								CD_BC_LANC
							FROM
								V_BC_CHQ_LANC_COMPENSADO
							WHERE
								V_BC_CHQ_LANC_COMPENSADO.CD_EMP		= BC_LANC.CD_EMP AND
								V_BC_CHQ_LANC_COMPENSADO.CD_BC_LANC = BC_LANC.CD_BC_LANC AND
								V_BC_CHQ_LANC_COMPENSADO.CD_CNT		= BC_LANC.CD_CNT AND
								V_BC_CHQ_LANC_COMPENSADO.DT_COMPES <= @DT_FIM)),0)


--VALOR REFERENTE AOS CHEQUES DE TERCEIROS NO CONCILIADOS
SET @VLR_CHQ_TERC = ISNULL((SELECT
						SUM(CASE WHEN BC_LANC.TP_LANC = 0 THEN CHQ_LANC_CPL.VLR_CHQ ELSE -CHQ_LANC_CPL.VLR_CHQ END) AS VLR_LANC
					FROM
						BC_LANC 
						INNER JOIN GLB_DOC ON
							BC_LANC.CD_EMP = GLB_DOC.CD_EMP AND 
							BC_LANC.CD_DOC = GLB_DOC.CD_DOC

						INNER JOIN BC_LANC_CHQ_DEPOS ON
							BC_LANC.CD_EMP = BC_LANC_CHQ_DEPOS.CD_EMP AND
							BC_LANC.CD_BC_LANC = BC_LANC_CHQ_DEPOS.CD_BC_LANC

						INNER JOIN CHQ_DEPOS_CPL ON
							BC_LANC_CHQ_DEPOS.CD_EMP = CHQ_DEPOS_CPL.CD_EMP AND
							BC_LANC_CHQ_DEPOS.CD_DEPOS = CHQ_DEPOS_CPL.CD_DEPOS AND
							BC_LANC_CHQ_DEPOS.ANO = CHQ_DEPOS_CPL.ANO

						INNER JOIN CHQ_LANC_CPL ON
							CHQ_DEPOS_CPL.CD_EMP = CHQ_LANC_CPL.CD_EMP AND
							CHQ_DEPOS_CPL.CD_CHQ = CHQ_LANC_CPL.CD_CHQ

					WHERE
						BC_LANC.CD_EMP = @CD_EMP
						AND BC_LANC.CD_CNT = @CD_CNT
						AND BC_LANC.DT_LANCTO <= @DT_FIM
						AND GLB_DOC.TP_DOC = 6
						AND NOT EXISTS (
							SELECT
								CD_BC_LANC
							FROM
								BC_LANC_BC_CHQ_LANC
							WHERE
								BC_LANC.CD_EMP = BC_LANC_BC_CHQ_LANC.CD_EMP AND
								BC_LANC.CD_BC_LANC = BC_LANC_BC_CHQ_LANC.CD_BC_LANC)
						AND NOT EXISTS (
							SELECT
								CD_BC_LANC
							FROM
								BC_LANC_CONC
							WHERE
								BC_LANC_CONC.CD_EMP		= BC_LANC.CD_EMP AND
								BC_LANC_CONC.CD_BC_LANC = BC_LANC.CD_BC_LANC AND
								BC_LANC_CONC.DT_COMPES <= @DT_FIM)),0)
						
--VALOR REFERENTE AOS CHEQUES DE TERCEIROS NO COMPENSADOS
SET @VLR_CHQ_SEM_COMP = ISNULL((SELECT
						SUM (CHQ_LANC_CPL.VLR_CHQ) AS VLR_CHQ
					FROM
						BC_LANC 
						INNER JOIN GLB_DOC ON
							BC_LANC.CD_EMP = GLB_DOC.CD_EMP AND 
							BC_LANC.CD_DOC = GLB_DOC.CD_DOC
						INNER JOIN BC_LANC_CHQ_DEPOS ON
							BC_LANC.CD_EMP		= BC_LANC_CHQ_DEPOS.CD_EMP AND
							BC_LANC.CD_BC_LANC	= BC_LANC_CHQ_DEPOS.CD_BC_LANC
						INNER JOIN CHQ_DEPOS_CPL ON
							BC_LANC_CHQ_DEPOS.CD_EMP	= CHQ_DEPOS_CPL.CD_EMP AND
							BC_LANC_CHQ_DEPOS.ANO		= CHQ_DEPOS_CPL.ANO AND
							BC_LANC_CHQ_DEPOS.CD_DEPOS  = CHQ_DEPOS_CPL.CD_DEPOS
						INNER JOIN CHQ_LANC_CPL ON
							CHQ_DEPOS_CPL.CD_EMP	= CHQ_LANC_CPL.CD_EMP AND
							CHQ_DEPOS_CPL.CD_CHQ	= CHQ_LANC_CPL.CD_CHQ
						INNER JOIN BC_LANC_CONC ON
							BC_LANC.CD_EMP		= BC_LANC_CONC.CD_EMP AND
							BC_LANC.CD_BC_LANC	= BC_LANC_CONC.CD_BC_LANC						
					WHERE
						BC_LANC.CD_EMP = @CD_EMP
						AND BC_LANC.CD_CNT = @CD_CNT
						AND GLB_DOC.TP_DOC = 6
						AND BC_LANC.DT_LANCTO <= @DT_FIM
						AND BC_LANC.DT_COMP <= @DT_FIM
						AND CHQ_LANC_CPL.DT_PREV_COMP >= @DT_FIM),0)

--VALOR REFERENTE AOS CHEQUES DE TERCEIROS REDEPOSITADOS NO COMPENSADOS
SET @VLR_CHQ_SEM_COMP = @VLR_CHQ_SEM_COMP + ISNULL((SELECT
						SUM (CHQ_LANC_CPL.VLR_CHQ) AS VLR_CHQ
					FROM
						BC_LANC 
						INNER JOIN GLB_DOC ON
							BC_LANC.CD_EMP = GLB_DOC.CD_EMP AND 
							BC_LANC.CD_DOC = GLB_DOC.CD_DOC
						INNER JOIN BC_LANC_CHQ_REDEPOS ON
							BC_LANC.CD_EMP		= BC_LANC_CHQ_REDEPOS.CD_EMP AND
							BC_LANC.CD_BC_LANC	= BC_LANC_CHQ_REDEPOS.CD_BC_LANC
						INNER JOIN CHQ_REDEPOS ON
							BC_LANC_CHQ_REDEPOS.CD_EMP		= CHQ_REDEPOS.CD_EMP AND							
							BC_LANC_CHQ_REDEPOS.CD_REDEPOS  = CHQ_REDEPOS.CD_REDEPOS
						INNER JOIN CHQ_LANC_CPL ON
							CHQ_REDEPOS.CD_EMP	= CHQ_LANC_CPL.CD_EMP AND
							CHQ_REDEPOS.CD_CHQ	= CHQ_LANC_CPL.CD_CHQ
						INNER JOIN BC_LANC_CONC ON
							BC_LANC.CD_EMP		= BC_LANC_CONC.CD_EMP AND
							BC_LANC.CD_BC_LANC	= BC_LANC_CONC.CD_BC_LANC						
					WHERE
						BC_LANC.CD_EMP = @CD_EMP
						AND BC_LANC.CD_CNT = @CD_CNT
						AND GLB_DOC.TP_DOC = 6
						AND BC_LANC.DT_LANCTO <= @DT_FIM
						AND BC_LANC.DT_COMP <= @DT_FIM
						AND CHQ_REDEPOS.DT_PREV_COMP >= @DT_FIM),0)
						

--VALOR REFERENTE AOS DEMAIS LANAMENTOS BANCRIOS
SET @VLR_BC_LANC = ISNULL((SELECT
						SUM(CASE WHEN BC_LANC.TP_LANC = 0 THEN VLR_LANC ELSE -VLR_LANC END) AS VLR_LANC
					FROM
						BC_LANC
						INNER JOIN GLB_DOC ON
							BC_LANC.CD_EMP = GLB_DOC.CD_EMP AND 
							BC_LANC.CD_DOC = GLB_DOC.CD_DOC
					WHERE
						BC_LANC.CD_EMP = @CD_EMP
						AND BC_LANC.CD_CNT = @CD_CNT
						AND BC_LANC.DT_LANCTO <= @DT_FIM
						AND NOT EXISTS (
							SELECT
								CD_BC_LANC
							FROM
								BC_LANC_BC_CHQ_LANC
							WHERE
								BC_LANC_BC_CHQ_LANC.CD_EMP		= BC_LANC.CD_EMP AND
								BC_LANC_BC_CHQ_LANC.CD_BC_LANC = BC_LANC.CD_BC_LANC)

						AND NOT EXISTS (
							SELECT
								CHQ_LANC.CD_BC_LANC
							FROM
								BC_LANC CHQ_LANC
								INNER JOIN GLB_DOC ON
									BC_LANC.CD_EMP = GLB_DOC.CD_EMP AND 
									BC_LANC.CD_DOC = GLB_DOC.CD_DOC
								INNER JOIN BC_LANC_CHQ_DEPOS ON
									BC_LANC.CD_EMP		= BC_LANC_CHQ_DEPOS.CD_EMP AND
									BC_LANC.CD_BC_LANC	= BC_LANC_CHQ_DEPOS.CD_BC_LANC
								INNER JOIN CHQ_DEPOS_CPL ON
									BC_LANC_CHQ_DEPOS.CD_EMP	= CHQ_DEPOS_CPL.CD_EMP AND
									BC_LANC_CHQ_DEPOS.ANO		= CHQ_DEPOS_CPL.ANO AND
									BC_LANC_CHQ_DEPOS.CD_DEPOS  = CHQ_DEPOS_CPL.CD_DEPOS
								INNER JOIN CHQ_LANC_CPL ON
									CHQ_DEPOS_CPL.CD_EMP	= CHQ_LANC_CPL.CD_EMP AND
									CHQ_DEPOS_CPL.CD_CHQ	= CHQ_LANC_CPL.CD_CHQ
							WHERE
								CHQ_LANC.CD_EMP		= BC_LANC.CD_EMP AND
								CHQ_LANC.CD_BC_LANC = BC_LANC.CD_BC_LANC)

						AND NOT EXISTS (
							SELECT
								CD_BC_LANC
							FROM
								BC_LANC_CONC
							WHERE
								BC_LANC_CONC.CD_EMP		= BC_LANC.CD_EMP AND
								BC_LANC_CONC.CD_BC_LANC = BC_LANC.CD_BC_LANC AND
								BC_LANC_CONC.DT_COMPES <= @DT_FIM)),0)


--PEGANDO O VALOR DOS CHEQUES QUE NO POSSUEM CONCILIAO OU COMPENSAO
SET @VLR_CHQ_SEM_CONC_COMP = ISNULL((SELECT
									SUM(CASE WHEN BC_LANC.TP_LANC = 0 THEN CHQ_LANC_CPL.VLR_CHQ ELSE - CHQ_LANC_CPL.VLR_CHQ END) AS VLR_LANC
								FROM
									BC_LANC 
									INNER JOIN GLB_DOC ON
										BC_LANC.CD_EMP = GLB_DOC.CD_EMP AND 
										BC_LANC.CD_DOC = GLB_DOC.CD_DOC

									INNER JOIN BC_LANC_CHQ_DEPOS ON
										BC_LANC.CD_EMP = BC_LANC_CHQ_DEPOS.CD_EMP AND
										BC_LANC.CD_BC_LANC = BC_LANC_CHQ_DEPOS.CD_BC_LANC

									INNER JOIN CHQ_DEPOS_CPL ON
										BC_LANC_CHQ_DEPOS.CD_EMP = CHQ_DEPOS_CPL.CD_EMP AND
										BC_LANC_CHQ_DEPOS.CD_DEPOS = CHQ_DEPOS_CPL.CD_DEPOS AND
										BC_LANC_CHQ_DEPOS.ANO = CHQ_DEPOS_CPL.ANO

									INNER JOIN CHQ_LANC_CPL ON
										CHQ_DEPOS_CPL.CD_EMP = CHQ_LANC_CPL.CD_EMP AND
										CHQ_DEPOS_CPL.CD_CHQ = CHQ_LANC_CPL.CD_CHQ

								WHERE
									BC_LANC.CD_EMP = @CD_EMP
									AND BC_LANC.CD_CNT = @CD_CNT
									AND BC_LANC.DT_LANCTO <= @DT_FIM
									AND GLB_DOC.TP_DOC = 6
									AND NOT EXISTS (
										SELECT
											CD_BC_LANC
										FROM
											BC_LANC_BC_CHQ_LANC
										WHERE
											BC_LANC.CD_EMP = BC_LANC_BC_CHQ_LANC.CD_EMP AND
											BC_LANC.CD_BC_LANC = BC_LANC_BC_CHQ_LANC.CD_BC_LANC)
									AND ( NOT EXISTS (
										SELECT
											CD_BC_LANC
										FROM
											BC_LANC_CONC
										WHERE
											BC_LANC_CONC.CD_EMP		= BC_LANC.CD_EMP AND
											BC_LANC_CONC.CD_BC_LANC = BC_LANC.CD_BC_LANC AND
											BC_LANC_CONC.DT_COMPES <= @DT_FIM)
										OR CHQ_LANC_CPL.DT_PREV_COMP >= @DT_FIM)),0)


--PEGANDO O LIMITE DA CONTA
SET @VLR_LIMITE = ISNULL((SELECT 
					ISNULL(VLR_LIMITE,0)
				  FROM 
					BC_CONTAS 
			      WHERE 
					CD_EMP = @CD_EMP
					AND CD_CNT = @CD_CNT),0)

--CHEQUES EM COMPENSAO NA DATA FINAL
SET @VLR_CHQ_COMPES = ISNULL((SELECT
						SUM (CHQ_LANC_CPL.VLR_CHQ) AS VLR_CHQ
					FROM
						BC_LANC 
						INNER JOIN BC_LANC_CHQ_DEPOS ON
							BC_LANC.CD_EMP		= BC_LANC_CHQ_DEPOS.CD_EMP AND
							BC_LANC.CD_BC_LANC	= BC_LANC_CHQ_DEPOS.CD_BC_LANC
						INNER JOIN CHQ_DEPOS_CPL ON
							BC_LANC_CHQ_DEPOS.CD_EMP	= CHQ_DEPOS_CPL.CD_EMP AND
							BC_LANC_CHQ_DEPOS.ANO		= CHQ_DEPOS_CPL.ANO AND
							BC_LANC_CHQ_DEPOS.CD_DEPOS  = CHQ_DEPOS_CPL.CD_DEPOS
						INNER JOIN CHQ_LANC_CPL ON
							CHQ_DEPOS_CPL.CD_EMP	= CHQ_LANC_CPL.CD_EMP AND
							CHQ_DEPOS_CPL.CD_CHQ	= CHQ_LANC_CPL.CD_CHQ 		
					WHERE
						BC_LANC.CD_EMP = @CD_EMP
						AND BC_LANC.CD_CNT = @CD_CNT
						AND CHQ_LANC_CPL.DT_PREV_COMP = @DT_FIM),0)
						
--VALOR REFERENTE AOS CHEQUES DE TERCEIROS REDEPOSITADOS NO COMPENSADOS
SET @VLR_CHQ_COMPES = @VLR_CHQ_COMPES + ISNULL((SELECT
						SUM (CHQ_LANC_CPL.VLR_CHQ) AS VLR_CHQ
					FROM
						BC_LANC 
						INNER JOIN BC_LANC_CHQ_REDEPOS ON
							BC_LANC.CD_EMP		= BC_LANC_CHQ_REDEPOS.CD_EMP AND
							BC_LANC.CD_BC_LANC	= BC_LANC_CHQ_REDEPOS.CD_BC_LANC
						INNER JOIN CHQ_REDEPOS ON
							BC_LANC_CHQ_REDEPOS.CD_EMP		= CHQ_REDEPOS.CD_EMP AND							
							BC_LANC_CHQ_REDEPOS.CD_REDEPOS  = CHQ_REDEPOS.CD_REDEPOS
						INNER JOIN CHQ_LANC_CPL ON
							CHQ_REDEPOS.CD_EMP	= CHQ_LANC_CPL.CD_EMP AND
							CHQ_REDEPOS.CD_CHQ	= CHQ_LANC_CPL.CD_CHQ		
					WHERE
						BC_LANC.CD_EMP = @CD_EMP
						AND BC_LANC.CD_CNT = @CD_CNT
						AND CHQ_REDEPOS.DT_PREV_COMP = @DT_FIM),0)


INSERT INTO @BC_LANC_EXTRATO (CD_EMP, CD_RET, DS_RET, VLR_RET)
					VALUES (@CD_EMP, 1, '(-) Cheques empresa no conciliados', @VLR_CHQ_EMP)

INSERT INTO @BC_LANC_EXTRATO (CD_EMP, CD_RET, DS_RET, VLR_RET)
					VALUES (@CD_EMP, 2, '(-) Cheques de terceiros no conciliados', @VLR_CHQ_TERC)

INSERT INTO @BC_LANC_EXTRATO (CD_EMP, CD_RET, DS_RET, VLR_RET)
					VALUES (@CD_EMP, 3, '(-) Cheques de terceiros no compensados', @VLR_CHQ_SEM_COMP)

INSERT INTO @BC_LANC_EXTRATO (CD_EMP, CD_RET, DS_RET, VLR_RET)
					VALUES (@CD_EMP, 4, '(-) Outros lanamentos bancrios no conciliados', @VLR_BC_LANC)

INSERT INTO @BC_LANC_EXTRATO (CD_EMP, CD_RET, DS_RET, VLR_RET)
					VALUES (@CD_EMP, 5, 'Saldo disponvel', @SLD_INI - @VLR_CHQ_EMP - @VLR_BC_LANC - @VLR_CHQ_SEM_CONC_COMP)

INSERT INTO @BC_LANC_EXTRATO (CD_EMP, CD_RET, DS_RET, VLR_RET)
					VALUES (@CD_EMP, 6, 'Limite da conta', @VLR_LIMITE)

INSERT INTO @BC_LANC_EXTRATO (CD_EMP, CD_RET, DS_RET, VLR_RET)
					VALUES (@CD_EMP, 7, 'Saldo + Limite',@SLD_INI - @VLR_CHQ_EMP - @VLR_BC_LANC - @VLR_CHQ_SEM_CONC_COMP + @VLR_LIMITE)

INSERT INTO @BC_LANC_EXTRATO (CD_EMP, CD_RET, DS_RET, VLR_RET)
					VALUES (@CD_EMP, 8, 'Cheques com previso de liberao em ' + CAST(CONVERT(VARCHAR(10), @DT_FIM, 103) AS VARCHAR), @VLR_CHQ_COMPES)

INSERT INTO @BC_LANC_EXTRATO (CD_EMP, CD_RET, DS_RET, VLR_RET)
					VALUES (@CD_EMP, 9, 'Saldo previsto para o dia ' + CAST(CONVERT(VARCHAR(10), @DT_FIM, 103) AS VARCHAR), @SLD_INI - @VLR_CHQ_EMP - @VLR_BC_LANC - @VLR_CHQ_SEM_CONC_COMP + @VLR_LIMITE + @VLR_CHQ_COMPES)

SET @VLR_CHQ_EMP = 0
SET @VLR_CHQ_COMPES = 0


IF @DT_FIM <> @DT_ATUAL
BEGIN
	SET @SLD_INI = ISNULL((SELECT DBO.UFD_BC_LANC_EXTRATO_SLD(@CD_EMP,@CD_CNT, DATEADD(day, 1, @DT_ATUAL),0)),0)

	SET @VLR_CHQ_EMP = ISNULL((SELECT
							SUM (VLR_LANC) AS VLR_LANC
						FROM
							BC_LANC INNER JOIN BC_LANC_BC_CHQ_LANC ON
								BC_LANC.CD_EMP = BC_LANC_BC_CHQ_LANC.CD_EMP AND
								BC_LANC.CD_BC_LANC = BC_LANC_BC_CHQ_LANC.CD_BC_LANC
						WHERE
							BC_LANC.CD_EMP = @CD_EMP
							AND BC_LANC.CD_CNT = @CD_CNT
							AND BC_LANC.TP_LANC = 1
							AND BC_LANC.DT_LANCTO <= @DT_ATUAL
							AND NOT BC_LANC.DT_COMP IS NULL --> @DT_BASE
							AND NOT EXISTS( SELECT
												CD_BC_LANC
											FROM
												V_BC_CHQ_LANC_COMPENSADO
											WHERE
												V_BC_CHQ_LANC_COMPENSADO.CD_EMP		= BC_LANC.CD_EMP AND
												V_BC_CHQ_LANC_COMPENSADO.CD_BC_LANC = BC_LANC.CD_BC_LANC AND
												V_BC_CHQ_LANC_COMPENSADO.CD_CNT		= BC_LANC.CD_CNT)),0)

	SET @VLR_CHQ_COMPES = ISNULL((SELECT
							SUM (CHQ_LANC_CPL.VLR_CHQ) AS VLR_CHQ
						FROM
							BC_LANC 
							INNER JOIN BC_LANC_CHQ_DEPOS ON
								BC_LANC.CD_EMP		= BC_LANC_CHQ_DEPOS.CD_EMP AND
								BC_LANC.CD_BC_LANC	= BC_LANC_CHQ_DEPOS.CD_BC_LANC
							INNER JOIN CHQ_DEPOS_CPL ON
								BC_LANC_CHQ_DEPOS.CD_EMP	= CHQ_DEPOS_CPL.CD_EMP AND
								BC_LANC_CHQ_DEPOS.ANO		= CHQ_DEPOS_CPL.ANO AND
								BC_LANC_CHQ_DEPOS.CD_DEPOS  = CHQ_DEPOS_CPL.CD_DEPOS
							INNER JOIN CHQ_LANC_CPL ON
								CHQ_DEPOS_CPL.CD_EMP	= CHQ_LANC_CPL.CD_EMP AND
								CHQ_DEPOS_CPL.CD_CHQ	= CHQ_LANC_CPL.CD_CHQ 		
						WHERE
							BC_LANC.CD_EMP = @CD_EMP
							AND BC_LANC.CD_CNT = @CD_CNT
							AND CHQ_LANC_CPL.DT_PREV_COMP = @DT_ATUAL),0)

	--PEGANDO O VALOR DOS CHEQUES QUE NO POSSUEM CONCILIAO OU COMPENSAO
	SET @VLR_CHQ_SEM_CONC_COMP = ISNULL((SELECT
									SUM(CASE WHEN BC_LANC.TP_LANC = 0 THEN CHQ_LANC_CPL.VLR_CHQ ELSE - CHQ_LANC_CPL.VLR_CHQ END) AS VLR_LANC
								FROM
									BC_LANC 
									INNER JOIN GLB_DOC ON
										BC_LANC.CD_EMP = GLB_DOC.CD_EMP AND 
										BC_LANC.CD_DOC = GLB_DOC.CD_DOC

									INNER JOIN BC_LANC_CHQ_DEPOS ON
										BC_LANC.CD_EMP = BC_LANC_CHQ_DEPOS.CD_EMP AND
										BC_LANC.CD_BC_LANC = BC_LANC_CHQ_DEPOS.CD_BC_LANC

									INNER JOIN CHQ_DEPOS_CPL ON
										BC_LANC_CHQ_DEPOS.CD_EMP = CHQ_DEPOS_CPL.CD_EMP AND
										BC_LANC_CHQ_DEPOS.CD_DEPOS = CHQ_DEPOS_CPL.CD_DEPOS AND
										BC_LANC_CHQ_DEPOS.ANO = CHQ_DEPOS_CPL.ANO

									INNER JOIN CHQ_LANC_CPL ON
										CHQ_DEPOS_CPL.CD_EMP = CHQ_LANC_CPL.CD_EMP AND
										CHQ_DEPOS_CPL.CD_CHQ = CHQ_LANC_CPL.CD_CHQ

								WHERE
									BC_LANC.CD_EMP = @CD_EMP
									AND BC_LANC.CD_CNT = @CD_CNT
									AND BC_LANC.DT_LANCTO <= @DT_ATUAL
									AND GLB_DOC.TP_DOC = 6
									AND NOT EXISTS (
										SELECT
											CD_BC_LANC
										FROM
											BC_LANC_BC_CHQ_LANC
										WHERE
											BC_LANC.CD_EMP = BC_LANC_BC_CHQ_LANC.CD_EMP AND
											BC_LANC.CD_BC_LANC = BC_LANC_BC_CHQ_LANC.CD_BC_LANC)
									AND ( NOT EXISTS (
										SELECT
											CD_BC_LANC
										FROM
											BC_LANC_CONC
										WHERE
											BC_LANC_CONC.CD_EMP		= BC_LANC.CD_EMP AND
											BC_LANC_CONC.CD_BC_LANC = BC_LANC.CD_BC_LANC AND
											BC_LANC_CONC.DT_COMPES <= @DT_ATUAL)
										OR CHQ_LANC_CPL.DT_PREV_COMP >= @DT_ATUAL)),0)


	INSERT INTO @BC_LANC_EXTRATO (CD_EMP, CD_RET, DS_RET, VLR_RET)
						VALUES (@CD_EMP, 10, 'Saldo previsto para hoje ' + CAST(CONVERT(VARCHAR(10), @DT_ATUAL, 103) AS VARCHAR), @SLD_INI - @VLR_CHQ_EMP - @VLR_BC_LANC - @VLR_CHQ_SEM_CONC_COMP + @VLR_LIMITE + @VLR_CHQ_COMPES)
END

RETURN
END

GO


